VERSION 5.00
Begin VB.Form SpectrumDemo 
   BackColor       =   &H00C0C0C0&
   Caption         =   "EPE Spectrum Analyser Demo"
   ClientHeight    =   6795
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9255
   Icon            =   "SpectrumDemo.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6795
   ScaleWidth      =   9255
   StartUpPosition =   1  'CenterOwner
   Begin VB.CheckBox Magnify 
      Caption         =   "Magnify Boxes 2-4"
      Height          =   225
      Left            =   6480
      TabIndex        =   15
      ToolTipText     =   "Increases plot height in relation to Round for better visibility of values"
      Top             =   0
      Width           =   1695
   End
   Begin VB.CommandButton Quit 
      BackColor       =   &H0000FF00&
      Caption         =   "Exit"
      Height          =   375
      Left            =   8400
      Style           =   1  'Graphical
      TabIndex        =   10
      ToolTipText     =   "Exit back to main screen"
      Top             =   0
      Width           =   755
   End
   Begin VB.CommandButton StartDemo 
      BackColor       =   &H00FFFF00&
      Caption         =   "Start"
      Height          =   465
      Left            =   8400
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   "Starts demo of principal analysis processes"
      Top             =   360
      Width           =   755
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   6480
      Top             =   5160
   End
   Begin VB.HScrollBar HScroll1 
      Height          =   225
      LargeChange     =   100
      Left            =   2520
      Max             =   1000
      Min             =   1
      SmallChange     =   10
      TabIndex        =   1
      Top             =   0
      Value           =   1000
      Width           =   3255
   End
   Begin VB.Label Label13 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Hover mouse cursor over buttons/labels for functional description"
      Height          =   255
      Left            =   120
      TabIndex        =   16
      ToolTipText     =   "Just as on the main screen"
      Top             =   6480
      Width           =   4695
   End
   Begin VB.Label Label12 
      Alignment       =   2  'Center
      BackColor       =   &H000000FF&
      Caption         =   "Finished"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   8400
      TabIndex        =   14
      ToolTipText     =   "Click on Start to show again"
      Top             =   6120
      Visible         =   0   'False
      Width           =   750
   End
   Begin VB.Label Label11 
      BackColor       =   &H00FFFF00&
      Caption         =   "Demo Rate Slider >"
      Height          =   225
      Left            =   120
      TabIndex        =   13
      ToolTipText     =   "Controls rate at which each demo analysis step is shown"
      Top             =   0
      Width           =   1455
   End
   Begin VB.Label Label10 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Slowest"
      Height          =   225
      Left            =   1920
      TabIndex        =   12
      ToolTipText     =   "Sets demo rate to slowest"
      Top             =   0
      Width           =   615
   End
   Begin VB.Label Label9 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Fastest"
      Height          =   225
      Left            =   5760
      TabIndex        =   11
      ToolTipText     =   "Sets demo rate to fastest"
      Top             =   0
      Width           =   615
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Caution - response to mouse clicks varies with demo rate"
      Height          =   255
      Left            =   5040
      TabIndex        =   9
      ToolTipText     =   "Don't always expect a speedy response!"
      Top             =   6480
      Width           =   4095
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "512"
      Height          =   225
      Left            =   8400
      TabIndex        =   8
      ToolTipText     =   "Click on 'Samples Span' to display a brief commentary"
      Top             =   1245
      Width           =   735
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Round 0"
      Height          =   225
      Left            =   8400
      TabIndex        =   7
      ToolTipText     =   "Click on 'Samples Span' to display a brief commentary"
      Top             =   1440
      Width           =   735
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Final Fully Sorted and Expanded Results"
      Height          =   1095
      Left            =   8400
      TabIndex        =   6
      ToolTipText     =   "Click anywhere on this panel's words to display a brief commentary"
      Top             =   5040
      Width           =   735
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Interim Combined     and      ""Sorted""  Results "
      Height          =   975
      Left            =   8400
      TabIndex        =   5
      ToolTipText     =   "Click anywhere on this panel's words to display a brief commentary"
      Top             =   3600
      Width           =   735
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Green = Real   Red = Imaginary"
      Height          =   855
      Left            =   8400
      TabIndex        =   4
      ToolTipText     =   "Click on 'Sample Trig Values' to display a brief commentary"
      Top             =   2400
      Width           =   735
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Sample Trig Values"
      Height          =   615
      Left            =   8400
      TabIndex        =   3
      ToolTipText     =   "Click on 'Sample Trig Values' to display a brief commentary"
      Top             =   1800
      Width           =   735
   End
   Begin VB.Shape Shape6 
      BackColor       =   &H0000FFFF&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H0000FFFF&
      Height          =   1455
      Left            =   8400
      Top             =   1800
      Width           =   735
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Samples Span ="
      Height          =   495
      Left            =   8400
      TabIndex        =   2
      ToolTipText     =   "Click on 'Samples Span' to display a brief commentary"
      Top             =   840
      Width           =   735
   End
   Begin VB.Shape Shape4 
      BackColor       =   &H00800000&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   1455
      Left            =   120
      Top             =   4920
      Width           =   8250
   End
   Begin VB.Shape Shape3 
      BackColor       =   &H00800000&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   1455
      Left            =   120
      Top             =   3360
      Width           =   8250
   End
   Begin VB.Shape Shape2 
      BackColor       =   &H00800000&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      FillColor       =   &H00800000&
      FillStyle       =   0  'Solid
      Height          =   1455
      Left            =   120
      Top             =   1800
      Width           =   8250
   End
   Begin VB.Shape Shape1 
      BackColor       =   &H00800000&
      BackStyle       =   1  'Opaque
      Height          =   1455
      Left            =   120
      Top             =   240
      Width           =   8250
   End
   Begin VB.Shape Shape7 
      BackColor       =   &H0000FFFF&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H0000FFFF&
      BorderWidth     =   2
      Height          =   1455
      Left            =   8400
      Top             =   3360
      Width           =   735
   End
   Begin VB.Shape Shape8 
      BackColor       =   &H0000FFFF&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H0000FFFF&
      BorderWidth     =   2
      Height          =   1455
      Left            =   8400
      Top             =   4920
      Width           =   735
   End
   Begin VB.Shape Shape5 
      BackColor       =   &H0000FFFF&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H0000FFFF&
      BorderWidth     =   2
      Height          =   1455
      Left            =   8400
      Top             =   240
      Width           =   735
   End
End
Attribute VB_Name = "SpectrumDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Spectrum Demo 21JUL01

Public Sub showinput()
Line (Boxleft - 2, Shape1.Top)-(Boxleft + 30, Shape1.Top + Shape1.Height), &H800000, BF
A = Samples(1) * 5: prevy = A + Box2Top: prevx = 1
For x = 1 To 1024: A = Samples(x) * 5 + Shape1.Top
C = (x + 2) * 8 + Boxleft: f = C + 20
Line (C, Shape1.Top)-(f, Shape1.Top + Shape1.Height), &H800000, BF
Line (prevx * 8 + Boxleft, prevy)-(x * 8 + Boxleft, A), vbYellow
prevy = A: prevx = x: Next
End Sub

Public Sub Analysis()

Bottom2 = Shape2.Height / 2 + Shape2.Top
Height2 = Shape2.Height - 100
Bottom3 = Shape3.Top + Shape3.Height
Bottom4 = Shape4.Top + Shape4.Height
Line (Shape2.Left, Shape2.Top)-(Shape2.Left + Shape2.Width, Shape2.Top + Shape2.Height), &H800000, BF
Line (Shape3.Left, Shape3.Top)-(Shape3.Left + Shape3.Width, Shape3.Top + Shape3.Height), &H800000, BF
Line (Shape4.Left, Shape4.Top)-(Shape4.Left + Shape4.Width, Shape4.Top + Shape4.Height), &H800000, BF
A = (HScroll1.Value): DelayX = 1 / A

For N = 1 To PlotLength: Imaginary(N) = 0
Real(N) = Samples(N) * (1 - Cosines(N)) / 2: Next

TrigIndexStep = 1: JumpSize = PlotLength: Span = PlotLength / 2
DepthCount = 1: Start = 1: Timer1.Enabled = True
Call showinput:: TrigIndex = 0
Label6.Caption = "Round " & DepthCount: Label6.Refresh
Label7.Caption = Span: Label7.Refresh

Call AnalysisPart2

End Sub

Public Sub AnalysisPart2():

Startloop:
Cosine = Cosines(TrigIndex): Sine = Sines(TrigIndex)
TrigIndex = TrigIndex + TrigIndexStep: previndex1 = Boxleft
For Index1 = Start To PlotLength Step JumpSize: Index2 = Index1 + Span

Line ((Index1 - 2) * 8 + Boxleft, 1650)-(Index1 * 8 + Boxleft, 1650), &H800000
Line (Index1 * 8 + Boxleft, 1650)-(Index2 * 8 + Boxleft, 1650), vbRed
previndex1 = Index1 * 8 + Boxleft: previndex2 = Index2 * 8 + Boxleft

If HScroll1.Value < 961 Then
t = Timer + DelayX
While Timer < t
Wend
End If

B = Samples(Index1) * 5 + Shape1.Top: C = Samples(Index2) * 5 + Shape1.Top
Line (Index1 * 8 + Boxleft, B)-(Index2 * 8 + Boxleft, C), vbGreen

RealDiff = Real(Index1) - Real(Index2)
ImaginaryDiff = Imaginary(Index1) - Imaginary(Index2)
Real(Index1) = Real(Index1) + Real(Index2)
Imaginary(Index1) = Imaginary(Index1) + Imaginary(Index2)
Real(Index2) = Cosine * RealDiff + Sine * ImaginaryDiff
Imaginary(Index2) = Cosine * ImaginaryDiff - Sine * RealDiff
      
B = Real(Index1) / 10
If Magnify.Value = 1 Then B = B * (11 - DepthCount)
If Abs(B) > Height2 / 2 Then B = (Height2 / 2) * Sgn(B)

C = Imaginary(Index1) / 10
If Magnify.Value = 1 Then C = C * (11 - DepthCount): ' * 10
If Abs(C) > Height2 / 2 Then C = (Height2 / 2) * Sgn(C)

Line (Index1 * 8 + Boxleft, Bottom2)-(Index1 * 8 + Boxleft, B + Bottom2), vbGreen
Line (Index1 * 8 + Boxleft, Bottom2)-(Index1 * 8 + Boxleft, C + Bottom2), vbRed

B = (Abs(Real(Index1)) + Abs(Imaginary(Index1))) / 25
If Magnify.Value = 1 Then B = B * (11 - DepthCount) * 3
If B > (Shape3.Height - 100) Then B = Shape3.Height - 100
d = Table(Index1)
Line (d * 8 + Boxleft, Bottom3 - 100)-(d * 8 + Boxleft, Bottom3 - B - 100), vbWhite
Next

Start = Start + 1:
If Start <= Span Then
If HScroll1.Value = 1000 Then GoTo Startloop
Exit Sub
End If

TrigIndexStep = TrigIndexStep * 2:  Span = Span / 2: JumpSize = JumpSize / 2:
DepthCount = DepthCount + 1: Start = 1: Call showinput: TrigIndex = 0

If DepthCount <= Depth Then
Label6.Caption = "Round " & DepthCount: Label6.Refresh
Label7.Caption = Span: Label7.Refresh
Line (Shape3.Left, Shape3.Top)-(Shape3.Left + Shape3.Width, Shape3.Top + Shape3.Height), &H800000, BF
If Magnify.Value = 1 Then Line (Shape2.Left, Shape2.Top)-(Shape2.Left + Shape2.Width, Shape2.Top + Shape2.Height), &H800000, BF
End If

If DepthCount <= Depth Then Exit Sub
Timer1.Enabled = False

For N = 1 To None: CalcSamples(N) = Abs(Imaginary(N)) + Abs(Real(N)): Next

Index = 1: For CountA = 1 To None
If CountA < Index Then
SwapReal = CalcSamples(Index): CalcSamples(Index) = CalcSamples(CountA): CalcSamples(CountA) = SwapReal
End If
S = PlotLength / 2
While S < Index: Index = Index - S: S = S / 2
Wend: Index = Index + S: Next

Maximum = 9.999999E-39
For N = 3 To None
If CalcSamples(N) > Maximum Then Maximum = CalcSamples(N)
Next

d = Shape4.Height - 100: e = d / Maximum: B = 0

For N = 3 To DisplayLength
  C = CalcSamples(N) * e
  If Magnify.Value = 1 Then
  C = C * 10: If C > Shape4.Height - 100 Then C = Shape4.Height - 100
  End If
  Line ((N - 2) * 16 + Boxleft, Bottom4 - B - 100)-((N - 1) * 16 + Boxleft, Bottom4 - C - 100), vbYellow
  B = C: Next
Beep
Label12.Visible = True
End Sub

Private Sub HScroll1_Change()
A = (HScroll1.Value): DelayX = 1 / A: '(A - 1) * 10000
End Sub

Private Sub Label10_Click()
HScroll1.Value = 1
End Sub

Private Sub Label1_Click()
AA$ = "Panel 1" & Chr(13) & Chr(13)
AA$ = AA$ & "Pairs of waveform values are sampled at intervals along the length of the full sample batch of 1024."
AA$ = AA$ & " On the first round the span between them is half the total number of samples (512). The analyis"
AA$ = AA$ & " relates the difference between the sample values to specific (pre-calculated) sine and"
AA$ = AA$ & " cosine values. Each result is stored in sequence. Sampling at this interval commences at sample 1"
AA$ = AA$ & " and proceeds for 512 samples. Round 2 then commences, again from sample 1, but this time the span"
AA$ = AA$ & " is half the previous (256) and this time 2 pairs of samples are taken, the second pair commencing"
AA$ = AA$ & " 256 places after sample 1. The process proceeds through 10 rounds, each round the span"
AA$ = AA$ & " being halved and the sample pairs doubled." & Chr(13) & Chr(13) & "Click OK and then click on next yellow panel."
MsgBox AA$, vbInformation
End Sub

Private Sub Label2_Click()
AA$ = "Panel 2" & Chr(13) & Chr(13)
AA$ = AA$ & "The second box shows the calculated sine/cosine values being stored in position as they occur."
AA$ = AA$ & " Paul Cuthbertson (see Panel 4) states that some are regarded as 'Real' and others as 'Imaginary', for reasons I do not understand."
AA$ = AA$ & " During analysis, the Real and Imaginary samples are combined in relation to their span positions,"
AA$ = AA$ & " so reducing the number of calculated samples, while increasing the values of those retained. The"
AA$ = AA$ & " sample positions retained are directly related to equivalent frequency spectrum value(s), the higher"
AA$ = AA$ & " the value, so the greater detected dominance of the equivalent frequency."
AA$ = AA$ & Chr(13) & Chr(13) & "This box (in normal mode)"
AA$ = AA$ & " shows all sample position values as they occur. In 'magnify' mode, only the retained values are shown in each round."
AA$ = AA$ & Chr(13) & Chr(13) & "In 'magnify' mode the sample values are also increased (in relation to the 'Round' number) to make the value differences more apparent."
AA$ = AA$ & Chr(13) & Chr(13) & "Click OK and then click on next yellow panel."
MsgBox AA$, vbInformation
End Sub

Private Sub Label4_Click()
AA$ = "Panel 3" & Chr(13) & Chr(13)
AA$ = AA$ & "The third box shows the 'retained' analysis values, but 'sorted' into their final frequency-related positions,"
AA$ = AA$ & " which are determined according to a complex mathematical notation. Again I do not understand the reasoning."
AA$ = AA$ & " However, I have analysed the relationship between the original and 'sorted' positions and a look-up table is"
AA$ = AA$ & " used to position the values in box 3. The table may be examined via a text editor. It is named SpectrumTable.txt"
AA$ = AA$ & " and is held in the same directory (folder) as the other Spectrum files."
AA$ = AA$ & Chr(13) & Chr(13) & "In 'magnify' mode the sample values are increased (in relation to the 'Round' number) to make the value differences more apparent."
AA$ = AA$ & Chr(13) & Chr(13) & "Click OK and then click on next yellow panel."
MsgBox AA$, vbInformation
End Sub

Private Sub Label5_Click()
AA$ = "Panel 4" & Chr(13) & Chr(13)
AA$ = AA$ & "The final box shows the graph of the final sorted analysis values. In the main Spectrum program there are frequency scales"
AA$ = AA$ & " associated with each of the sampling rates (3 if you are using the EPE Spectrum Analyser board, 2 if using the EPE PIC Dual-Chan Virtual Scope)."
AA$ = AA$ & " You can fine-tune the scales (using a signal generator) to suit minor differences between your unit and mine. The scales can be stored to disk for recall next"
AA$ = AA$ & " time you use this software."
AA$ = AA$ & Chr(13) & Chr(13) & "Paul Cuthbertson was the designer of a Spectrum Analyser published in EPE's sister publication The Modern Electronics Manual (MEM)."
AA$ = AA$ & " It is a modification of his analysis software routine that I have used as the heart of this Spectrum Analyser. His original QBasic routines (written for his own hardware)"
AA$ = AA$ & " can be read as a text file, SpectrumMEM.txt, that accompanies this program and which has various explanatory comments."
AA$ = AA$ & " Sadly, Paul departed to the 'Other Spectrum' early in 2001."
AA$ = AA$ & Chr(13) & Chr(13) & "John Becker, 21 July 2001"
MsgBox AA$, vbInformation
End Sub

Private Sub Label9_Click()
HScroll1.Value = 1000
End Sub

Private Sub Quit_Click()
Timer1.Enabled = False: SpectrumMain.Show
B = 0: For A = 0 To 4: If SpectrumMain.Option1(A) = True Then B = A: Exit For
Next
SpectrumMain.Text1(B).Visible = True: SpectrumMain.Text2(B).Visible = True
Call SpectrumMain.showinput
Call SpectrumMain.Analysis
End Sub

Public Sub StartDemo_Click()
Label12.Visible = False: Call Analysis
End Sub

Private Sub Timer1_Timer()
A = (HScroll1.Value): DelayX = 1 / A: Call AnalysisPart2
End Sub
